import { Header } from "@/components/layout/header";
import { Footer } from "@/components/layout/footer";
import { Button } from "@/components/ui/button";
import { ContactSection } from "@/components/ui/contact-section";
import { CTASection } from "@/components/ui/cta-section";
import { Link } from "wouter";

export default function ESMPPage() {
  return (
    <>
      <Header />
      <main>
        {/* Hero Section */}
        <section className="pt-28 pb-20 px-4 sm:px-6 lg:px-8 bg-gradient-to-r from-accent-500 to-accent-600 text-white">
          <div className="container mx-auto">
            <div className="grid md:grid-cols-2 gap-12 items-center">
              <div>
                <h1 className="text-4xl md:text-5xl font-bold mb-6">ESMP Implementation Services</h1>
                <p className="text-xl text-accent-50 mb-8">
                  Configure Enterprise Service Management Platform to streamline cross-department service delivery 
                  and improve organizational efficiency.
                </p>
                <Button 
                  asChild
                  size="lg" 
                  className="bg-white text-accent-600 hover:bg-accent-50"
                >
                  <Link href="#esmp-features">Explore Features</Link>
                </Button>
              </div>
              
              <div className="flex justify-center">
                <div className="w-full max-w-lg p-6 bg-white rounded-lg shadow-xl">
                  <div className="flex items-center mb-6">
                    <i className="fas fa-server text-4xl text-accent-500 mr-3"></i>
                    <h3 className="text-2xl font-bold text-slate-900">ESMP Platform</h3>
                  </div>
                  <div className="space-y-4 text-slate-800">
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-accent-500 mt-1 mr-2"></i>
                      <p>Cross-department service management</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-accent-500 mt-1 mr-2"></i>
                      <p>Enterprise-wide workflow automation</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-accent-500 mt-1 mr-2"></i>
                      <p>Unified self-service portal</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-accent-500 mt-1 mr-2"></i>
                      <p>Comprehensive reporting & analytics</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        {/* Features Section */}
        <section id="esmp-features" className="py-20 bg-white px-4 sm:px-6 lg:px-8">
          <div className="container mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">ESMP Implementation Features</h2>
              <p className="text-lg text-slate-600 max-w-2xl mx-auto">
                Our expert team configures ESMP to streamline service delivery across all departments in your organization.
              </p>
            </div>
            
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-accent-100 text-accent-500 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-building text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Multi-Department Setup</h3>
                <p className="text-slate-600">
                  Configure service management processes for IT, HR, Facilities, Finance, and other departments
                  with a unified experience.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-accent-100 text-accent-500 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-cogs text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Process Automation</h3>
                <p className="text-slate-600">
                  Implement automated workflows that span multiple departments to streamline approvals,
                  notifications, and service delivery.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-accent-100 text-accent-500 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-users text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Self-Service Portal</h3>
                <p className="text-slate-600">
                  Configure a unified self-service portal where users can request services from any department
                  through an intuitive interface.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-accent-100 text-accent-500 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-exchange-alt text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">System Integration</h3>
                <p className="text-slate-600">
                  Connect ESMP with existing systems like HR software, financial applications, and IT management tools.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-accent-100 text-accent-500 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-chart-line text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Advanced Analytics</h3>
                <p className="text-slate-600">
                  Set up comprehensive reporting dashboards that provide insights into service performance
                  across the entire organization.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-accent-100 text-accent-500 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-shield-alt text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Security & Compliance</h3>
                <p className="text-slate-600">
                  Implement role-based access controls and compliance workflows to ensure secure and
                  compliant service management.
                </p>
              </div>
            </div>
          </div>
        </section>
        
        {/* Case Study Section */}
        <section className="py-20 bg-slate-50 px-4 sm:px-6 lg:px-8">
          <div className="container mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">ESMP Success Story</h2>
              <p className="text-lg text-slate-600 max-w-2xl mx-auto">
                See how our ESMP implementation transformed service delivery for a global enterprise.
              </p>
            </div>
            
            <div className="bg-white rounded-xl shadow-md overflow-hidden">
              <div className="md:flex">
                <div className="md:flex-shrink-0 md:w-1/3">
                  <div className="h-64 md:h-full w-full bg-[url('https://images.unsplash.com/photo-1568992688065-536aad8a12f6?ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=80')] bg-cover bg-center"></div>
                </div>
                <div className="p-8 md:w-2/3">
                  <div className="uppercase tracking-wide text-sm text-accent-500 font-semibold">Case Study</div>
                  <h3 className="mt-1 text-2xl font-bold text-slate-900 leading-tight">Global Manufacturing Corporation</h3>
                  <p className="mt-2 text-slate-600">
                    A global manufacturing company with 15,000 employees across 12 countries struggled with siloed service 
                    processes across departments. We implemented ESMP to create a unified service experience.
                  </p>
                  
                  <div className="mt-6 grid md:grid-cols-3 gap-4 text-sm">
                    <div className="bg-slate-50 p-3 rounded">
                      <div className="text-accent-500 font-bold">Challenge</div>
                      <p>Fragmented services across IT, HR, Facilities and Finance causing delays and confusion</p>
                    </div>
                    
                    <div className="bg-slate-50 p-3 rounded">
                      <div className="text-accent-500 font-bold">Solution</div>
                      <p>Unified ESMP implementation with cross-department workflows and self-service portal</p>
                    </div>
                    
                    <div className="bg-slate-50 p-3 rounded">
                      <div className="text-accent-500 font-bold">Results</div>
                      <p>42% faster service delivery, 68% increase in user satisfaction, $1.2M annual savings</p>
                    </div>
                  </div>
                  
                  <div className="mt-6">
                    <Button
                      asChild
                      className="bg-accent-500 hover:bg-accent-600 text-white"
                    >
                      <Link href="#contact">Request Similar Results</Link>
                    </Button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        <CTASection />
        <ContactSection />
      </main>
      <Footer />
    </>
  );
}
