import { Header } from "@/components/layout/header";
import { Footer } from "@/components/layout/footer";
import { Button } from "@/components/ui/button";
import { ContactSection } from "@/components/ui/contact-section";
import { CTASection } from "@/components/ui/cta-section";
import { Link } from "wouter";

export default function JiraPage() {
  return (
    <>
      <Header />
      <main>
        {/* Hero Section */}
        <section className="pt-28 pb-20 px-4 sm:px-6 lg:px-8 bg-gradient-to-r from-primary-600 to-primary-700 text-white">
          <div className="container mx-auto">
            <div className="grid md:grid-cols-2 gap-12 items-center">
              <div>
                <h1 className="text-4xl md:text-5xl font-bold mb-6">Jira Service Management Configuration</h1>
                <p className="text-xl text-primary-50 mb-8">
                  Optimize your Jira Service Management instance with custom workflows, automation rules, 
                  and integrations tailored to your organization's specific needs.
                </p>
                <Button 
                  asChild
                  size="lg" 
                  className="bg-white text-primary-600 hover:bg-primary-50"
                >
                  <Link href="#jira-features">Explore Features</Link>
                </Button>
              </div>
              
              <div className="flex justify-center">
                <div className="w-full max-w-lg p-6 bg-white rounded-lg shadow-xl">
                  <div className="flex items-center mb-6">
                    <i className="fab fa-jira text-4xl text-primary-600 mr-3"></i>
                    <h3 className="text-2xl font-bold text-slate-900">Jira Service Management</h3>
                  </div>
                  <div className="space-y-4 text-slate-800">
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-primary-600 mt-1 mr-2"></i>
                      <p>Enterprise-grade service management platform</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-primary-600 mt-1 mr-2"></i>
                      <p>Customizable workflows and automation</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-primary-600 mt-1 mr-2"></i>
                      <p>ITIL-aligned processes</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-primary-600 mt-1 mr-2"></i>
                      <p>Rich integration capabilities</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        {/* Features Section */}
        <section id="jira-features" className="py-20 bg-white px-4 sm:px-6 lg:px-8">
          <div className="container mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">Jira Service Management Features</h2>
              <p className="text-lg text-slate-600 max-w-2xl mx-auto">
                Our expert team configures and customizes all aspects of your Jira Service Management platform
                to deliver maximum value.
              </p>
            </div>
            
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-sitemap text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Custom Workflows</h3>
                <p className="text-slate-600">
                  Design and implement workflows that match your organization's processes exactly, 
                  ensuring efficient ticket handling and routing.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-robot text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Automation Rules</h3>
                <p className="text-slate-600">
                  Set up powerful automation rules to handle routine tasks, reduce manual work, 
                  and ensure consistent service delivery.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-tachometer-alt text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">SLA Configuration</h3>
                <p className="text-slate-600">
                  Define and implement service level agreements that align with your business requirements
                  and customer expectations.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-puzzle-piece text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">App Integrations</h3>
                <p className="text-slate-600">
                  Extend functionality with third-party app integrations that connect Jira to your
                  existing tools and platforms.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-chart-bar text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Custom Reporting</h3>
                <p className="text-slate-600">
                  Create dashboards and reports that provide actionable insights into service performance,
                  team productivity, and customer satisfaction.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-users text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Customer Portal</h3>
                <p className="text-slate-600">
                  Configure a user-friendly customer portal that makes it easy for users to submit
                  requests and track their status.
                </p>
              </div>
            </div>
          </div>
        </section>
        
        {/* Implementation Process */}
        <section className="py-20 bg-slate-50 px-4 sm:px-6 lg:px-8">
          <div className="container mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Implementation Approach</h2>
              <p className="text-lg text-slate-600 max-w-2xl mx-auto">
                We follow a structured methodology to ensure your Jira Service Management implementation 
                is successful and delivers lasting value.
              </p>
            </div>
            
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
              <div className="relative pb-12 md:pb-0">
                <div className="absolute left-0 md:left-1/2 h-full w-0.5 bg-primary-200 hidden md:block"></div>
                <div className="flex md:block md:text-center relative z-10">
                  <div className="w-16 h-16 bg-primary-600 text-white rounded-full flex items-center justify-center mb-4 mr-4 md:mx-auto">
                    <span className="text-xl font-bold">1</span>
                  </div>
                  <div className="md:mt-4">
                    <h3 className="text-xl font-bold mb-2">Requirements Analysis</h3>
                    <p className="text-slate-600">
                      We analyze your current processes, pain points, and goals to create a comprehensive implementation plan.
                    </p>
                  </div>
                </div>
              </div>
              
              <div className="relative pb-12 md:pb-0">
                <div className="absolute left-0 md:left-1/2 h-full w-0.5 bg-primary-200 hidden md:block"></div>
                <div className="flex md:block md:text-center relative z-10">
                  <div className="w-16 h-16 bg-primary-600 text-white rounded-full flex items-center justify-center mb-4 mr-4 md:mx-auto">
                    <span className="text-xl font-bold">2</span>
                  </div>
                  <div className="md:mt-4">
                    <h3 className="text-xl font-bold mb-2">Design & Configuration</h3>
                    <p className="text-slate-600">
                      We design and configure workflows, forms, automation rules, and integrations to match your requirements.
                    </p>
                  </div>
                </div>
              </div>
              
              <div className="relative pb-12 md:pb-0">
                <div className="absolute left-0 md:left-1/2 h-full w-0.5 bg-primary-200 hidden md:block"></div>
                <div className="flex md:block md:text-center relative z-10">
                  <div className="w-16 h-16 bg-primary-600 text-white rounded-full flex items-center justify-center mb-4 mr-4 md:mx-auto">
                    <span className="text-xl font-bold">3</span>
                  </div>
                  <div className="md:mt-4">
                    <h3 className="text-xl font-bold mb-2">Testing & Validation</h3>
                    <p className="text-slate-600">
                      We thoroughly test all configurations and workflows to ensure they function as expected.
                    </p>
                  </div>
                </div>
              </div>
              
              <div className="relative">
                <div className="flex md:block md:text-center relative z-10">
                  <div className="w-16 h-16 bg-primary-600 text-white rounded-full flex items-center justify-center mb-4 mr-4 md:mx-auto">
                    <span className="text-xl font-bold">4</span>
                  </div>
                  <div className="md:mt-4">
                    <h3 className="text-xl font-bold mb-2">Training & Handover</h3>
                    <p className="text-slate-600">
                      We provide comprehensive training and documentation to ensure your team can effectively use and maintain the system.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        <CTASection />
        <ContactSection />
      </main>
      <Footer />
    </>
  );
}
